/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge.addons.framedblocks;

import com.fizzware.dramaticdoors.forge.forge.addons.framedblocks.TallDoorSkipPredicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.VoxelShapeGenerator;
import xfacthd.framedblocks.common.block.door.FramedDoorBlock;

public enum DDBlockType implements IBlockType
{
    FRAMED_TALL_DOOR(true, false, false, false, true, false, true, false, FramedDoorBlock.CTM_PREDICATE, new TallDoorSkipPredicate()),
    FRAMED_TALL_IRON_DOOR(true, false, false, false, true, false, true, false, FramedDoorBlock.CTM_PREDICATE, new TallDoorSkipPredicate());

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final boolean lockable;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final VoxelShapeGenerator shapeGen;

    private DDBlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, skipPredicate, VoxelShapeGenerator.EMTPTY);
    }

    private DDBlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.lockable = lockable;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    public int compareTo(IBlockType other) {
        if (!(other instanceof DDBlockType)) {
            return 1;
        }
        DDBlockType type = (DDBlockType)other;
        return this.compareTo(type);
    }

    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    public String getName() {
        return this.name;
    }

    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    public boolean hasBlockItem() {
        return this.blockItem;
    }

    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    public boolean canLockState() {
        return this.lockable;
    }

    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }
}

